package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Request;

//OperationalRequest Mainframe documents
public class OMDocumentRuleEvaluator extends OperationalDocumentRuleEvaluator {

	@Override
	public boolean isRequired(final Request req, final DataSource ds, final DocumentTemplate temp, final Participant participant, final boolean isIndependentOnly) {

		if (temp.getName().startsWith("CDW Justification Memo")) {
			return true;
		}

//As of 3/1, they don't want to require the Data Access Agreement for Operations		
//		// VHA Privacy Data Access Agreement is required of all participants
//		if (temp.getName().startsWith("VHA Privacy Data Access Agreement")) {
//			return true;
//		}
		
//As of 3/23/2015, VA Form 9957 is no longer required for any NDS data source (probably true for Operations also -- need to verify once Operations is turned back on)
//		// VA Form 9957 is required of all participants
//		if (temp.getName().startsWith("VA Form 9957")) {
//			return true;
//		}

		
		return false;
	}
}
